/******************************************************************************
*
* (c) Copyright 2010-12 Xilinx, Inc. All rights reserved.
*
* This file contains confidential and proprietary information of Xilinx, Inc.
* and is protected under U.S. and international copyright and other
* intellectual property laws.
*
* DISCLAIMER
* This disclaimer is not a license and does not grant any rights to the
* materials distributed herewith. Except as otherwise provided in a valid
* license issued to you by Xilinx, and to the maximum extent permitted by
* applicable law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND WITH ALL
* FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES AND CONDITIONS, EXPRESS,
* IMPLIED, OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
* MERCHANTABILITY, NON-INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE;
* and (2) Xilinx shall not be liable (whether in contract or tort, including
* negligence, or under any other theory of liability) for any loss or damage
* of any kind or nature related to, arising under or in connection with these
* materials, including for any direct, or any indirect, special, incidental,
* or consequential loss or damage (including loss of data, profits, goodwill,
* or any type of loss or damage suffered as a result of any action brought by
* a third party) even if such damage or loss was reasonably foreseeable or
* Xilinx had been advised of the possibility of the same.
*
* CRITICAL APPLICATIONS
* Xilinx products are not designed or intended to be fail-safe, or for use in
* any application requiring fail-safe performance, such as life-support or
* safety devices or systems, Class III medical devices, nuclear facilities,
* applications related to the deployment of airbags, or any other applications
* that could lead to death, personal injury, or severe property or
* environmental damage (individually and collectively, "Critical
* Applications"). Customer assumes the sole risk and liability of any use of
* Xilinx products in Critical Applications, subject only to applicable laws
* and regulations governing limitations on product liability.
*
* THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS PART OF THIS FILE
* AT ALL TIMES.
*
******************************************************************************/
/****************************************************************************/
/**
*
* @file xscuwdt_hw.h
*
* This file contains the hardware interface to the Xilinx SCU private Watch Dog
* Timer (XSCUWDT).
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who Date     Changes
* ----- --- -------- ---------------------------------------------
* 1.00a sdm 01/15/10 First release
* 1.01a bss 02/27/12 Updated the register offsets to start at 0x0 instead
*                    of 0x20 as the base address obtained from the tools
*		     starts at 0x20.
* 1.02a  sg 07/17/12 Included xil_assert.h for CR 667947. This is an issue
*		     when the xstatus.h in the common driver overwrites
*		     the xstatus.h of the standalone BSP during the
*		     libgen.
* </pre>
*
******************************************************************************/
#ifndef XSCUWDT_HW_H		/* prevent circular inclusions */
#define XSCUWDT_HW_H		/* by using protection macros */

#ifdef __cplusplus
extern "C" {
#endif

/***************************** Include Files *********************************/

#include "xil_types.h"
#include "xil_io.h"
#include "xil_assert.h"
/************************** Constant Definitions *****************************/

/** @name Register Map
 * Offsets of registers from the start of the device. The WDT registers start at
 * an offset 0x20
 * @{
 */

#define XSCUWDT_LOAD_OFFSET	0x00 /**< Watchdog Load Register */
#define XSCUWDT_COUNTER_OFFSET	0x04 /**< Watchdog Counter Register */
#define XSCUWDT_CONTROL_OFFSET	0x08 /**< Watchdog Control Register */
#define XSCUWDT_ISR_OFFSET	0x0C /**< Watchdog Interrupt Status Register */
#define XSCUWDT_RST_STS_OFFSET	0x10 /**< Watchdog Reset Status Register */
#define XSCUWDT_DISABLE_OFFSET	0x14 /**< Watchdog Disable Register */
/* @} */

/** @name Watchdog Control register
 * This register bits control the prescaler, WD/Timer mode, Intr enable,
 * auto-reload, watchdog enable.
 * @{
 */

#define XSCUWDT_CONTROL_PRESCALER_MASK	 0x0000FF00 /**< Prescaler */
#define XSCUWDT_CONTROL_PRESCALER_SHIFT	 8
#define XSCUWDT_CONTROL_WD_MODE_MASK	 0x00000008 /**< Watchdog/Timer mode */
#define XSCUWDT_CONTROL_IT_ENABLE_MASK	 0x00000004 /**< Intr enable (in
							 timer mode) */
#define XSCUWDT_CONTROL_AUTO_RELOAD_MASK 0x00000002 /**< Auto-reload (in
							 timer mode) */
#define XSCUWDT_CONTROL_WD_ENABLE_MASK	 0x00000001 /**< Watchdog enable */
/* @} */

/** @name Interrupt Status register
 * This register indicates the Counter register has reached zero in Counter
 * mode.
 * @{
 */

#define XSCUWDT_ISR_EVENT_FLAG_MASK	0x00000001 /**< Event flag */
/*@}*/

/** @name Reset Status register
 * This register indicates the Counter register has reached zero in Watchdog
 * mode and a reset request is sent.
 * @{
 */

#define XSCUWDT_RST_STS_RESET_FLAG_MASK	0x00000001 /**< Time out occured */
/*@}*/

/** @name Disable register
 * This register is used to switch from watchdog mode to timer mode.
 * The software must write 0x12345678 and 0x87654321 successively to the
 * Watchdog Disable Register so that the watchdog mode bit in the Watchdog
 * Control Register is set to zero.
 * @{
 */
#define XSCUWDT_DISABLE_VALUE1		0x12345678 /**< Watchdog mode disable
							value 1 */
#define XSCUWDT_DISABLE_VALUE2		0x87654321 /**< Watchdog mode disable
							value 2 */
/*@}*/

/**************************** Type Definitions *******************************/

/***************** Macros (Inline Functions) Definitions *********************/

/****************************************************************************/
/**
*
* Read the given register.
*
* @param	BaseAddr is the base address of the device
* @param	RegOffset is the register offset to be read
*
* @return	The 32-bit value of the register
*
* @note		C-style signature:
*		u32 XScuWdt_ReadReg(u32 BaseAddr, u32 RegOffset)
*
*****************************************************************************/
#define XScuWdt_ReadReg(BaseAddr, RegOffset)		\
	Xil_In32((BaseAddr) + (RegOffset))

/****************************************************************************/
/**
*
* Write the given register.
*
* @param	BaseAddr is the base address of the device
* @param	RegOffset is the register offset to be written
* @param	Data is the 32-bit value to write to the register
*
* @return	None.
*
* @note		C-style signature:
*		void XScuWdt_WriteReg(u32 BaseAddr, u32 RegOffset, u32 Data)
*
*****************************************************************************/
#define XScuWdt_WriteReg(BaseAddr, RegOffset, Data)	\
	Xil_Out32((BaseAddr) + (RegOffset), (Data))

/************************** Function Prototypes ******************************/

/************************** Variable Definitions *****************************/

#ifdef __cplusplus
}
#endif

#endif	/* end of protection macro */
